<?php

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateInfixModuleInfosTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('infix_module_infos', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('module_id')->nullable();
            $table->integer('parent_id')->nullable()->default(0);
            $table->string('name')->nullable();
            $table->tinyInteger('is_saas')->default(0);
            $table->string('route')->nullable();
            $table->string('lang_name')->nullable();
            $table->string('icon_class')->nullable();
            $table->tinyInteger('active_status')->default(1);
            $table->integer('created_by')->nullable()->default(1)->unsigned();
            $table->foreign('created_by')->references('id')->on('users')->onDelete('cascade');

            $table->integer('updated_by')->nullable()->default(1)->unsigned();
            $table->foreign('updated_by')->references('id')->on('users')->onDelete('cascade');

            $table->integer('school_id')->nullable()->unsigned();
            $table->foreign('school_id')->references('id')->on('sm_schools')->onDelete('cascade');

            $table->integer('type')->nullable()->comment('1 for module, 2 for module link, 3 for module links crud');

            $table->timestamps();
        });


        DB::statement('SET foreign_key_checks=0');
        DB::table('infix_module_infos')->truncate();
        DB::statement('SET foreign_key_checks=1');

        $sql = ("INSERT INTO `infix_module_infos` (`id`, `module_id`, `parent_id`, `type`, `is_saas`, `name`, `route`, `lang_name`, `icon_class`, `active_status`, `created_by`, `updated_by`, `school_id`, `created_at`, `updated_at`) VALUES
        (1, 1, 0, '1', 0,'Dashboard','','dashboard','flaticon-speedometer', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (2, 1, 1, '3', 0,'➡ Number of Student','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (3, 1, 1, '3', 0,'➡ Number of Teacher','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (4, 1, 1, '3', 0,'➡ Number of Parents','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (5, 1, 1, '3', 0,'➡ Number of Staff','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (6, 1, 1, '3', 0,'➡ Current Month Income and Expense Chart','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (7, 1, 1, '3', 0,'➡ Current Year Income and Expense Chart','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (8, 1, 1, '3', 0,'➡ Notice Board','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (9, 1, 1, '3', 0,'➡ Calendar Section','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (10, 1, 1, '3',0, '➡ To Do list','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

    
            -- Saas Dashboard Menu

        (601, 21, 0, '1','1', 'Saas Dashboard','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (603, 21, 601, '3','1', '➡ Active Student','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (604, 21, 601, '3','1', '➡ Inactive Student','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (605, 21, 601, '3','1', '➡ Total Parents','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (680, 21, 601, '3','1', '➡ Total Teacher','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (681, 21, 601, '3','1', '➡ Total Institute','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (682, 21, 601, '3','1', '➡ Total Staffs','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (683, 21, 601, '3','1', '➡ Total Saas Staffs','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        -- Saas Institution List

        (606, 22, 0, '1','1', 'Saas Institution','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (607, 22, 606, '3','1', ' List','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (608, 22, 606, '3','1', ' Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (609, 22, 606, '3','1', ' Login Access','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (610, 22, 606, '3','1', ' Disable','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (685, 22, 606, '3','1', ' Deatil','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

       -- Saas Communicate

        (611, 23, 0, '1','1', 'Saas Communicate','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (612, 23, 611, '3','1', 'Send Mail','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (613, 23, 611, '3','1', 'Send Sms','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (614, 23, 611, '3','1', 'Send Notice','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        -- Saas Reports

        (641, 24, 0, '1','1', 'Saas Reports','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (642, 24, 641, '3','1', 'Student List','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (643, 24, 641, '3','1', 'Income/Expense','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (644, 24, 641, '3','1', 'Teacher List','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (645, 24, 641, '3','1', 'Class List','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (646, 24, 641, '3','1', 'Class Routine','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (647, 24, 641, '3','1', 'Student Attendence','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (648, 24, 641, '3','1', 'Staff Attendence','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (649, 24, 641, '3','1', 'Merit List','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        
        
       
         -- Saas System Setting

        (620, 25, 0, '1','1', 'Saas System Setting','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (621, 25, 620, '3','1', 'Saas Role','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (660, 25, 620, '3','1', 'Email Template','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (661, 25, 620, '3','1', 'Sms Template','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (662, 25, 620, '3','1', 'About','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),



        -- Saas Api
        (635, 27, 0, '1','1', 'Saas Api','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (636, 27, 635, '3','1', 'Api Setting','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        -- Saas HRM
        (638, 26, 0, '1','1', 'Human Resource','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (669, 26, 638, '3','1', 'Designation','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (670, 26, 638, '3','1', 'Department','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (671, 26, 638, '3','1', 'Add Staff','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (672, 26, 638, '3','1', 'Staff Directory','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),




        -- Admin Section Menu
        (11, 2, 0, '1',  0, 'Admin Section','','admin_section','flaticon-analytics', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (12, 2, 11, '2', 0,  'Admission Query','admission_query','admission_query','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (13, 2, 12, '3', 0,  'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (14, 2, 12, '3', 0,  'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (15, 2, 12, '3', 0,  'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (16, 2, 11, '2', 0, 'Visitor Book','visitor','visitor','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (17, 2, 16, '3', 0, 'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (18, 2, 16, '3', 0, 'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (19, 2, 16, '3', 0, 'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (20, 2, 16, '3', 0, 'Download','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (21, 2, 11, '2',0, 'Complaint','complaint','complaint','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (22, 2, 21, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (23, 2, 21, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (24, 2, 21, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (25, 2, 21, '3', 0,'Download','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (26, 2, 21, '3', 0,'View','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (27, 2, 11, '2', 0,'Postal Receive','postal-receive','postal_receive','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (28, 2, 27, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (29, 2, 27, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (30, 2, 27, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (31, 2, 27, '3', 0,'Download','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (32, 2, 11, '2', 0,'Postal Dispatch','postal-dispatch','postal_dispatch','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (33, 2, 32, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (34, 2, 32, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (35, 2, 32, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (36, 2, 11, '2', 0,'Phone Call Log','phone-call','phone_call','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (37, 2, 36, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (38, 2, 36, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (39, 2, 36, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (40, 2, 36, '3',0, 'Download','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),


        (41, 2, 11, '2', 0,'Admin Setup','setup-admin','setup_admin','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (42, 2, 41, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (43, 2, 41, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (44, 2, 41, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (45, 2, 11, '2', 0,'Student ID Card','student-id-card','student_id_card','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (46, 2, 45, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (47, 2, 45, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (48, 2, 45, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (49, 2, 11, '2', 0,'Student Certificate','student-certificate','student_certificate','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (50, 2, 49, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (51, 2, 49, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (52, 2, 49, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (53, 2, 11, '2', 0,'Generate Certificate','generate_certificate','generate_certificate','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (54, 2, 53, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (55, 2, 53, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (56, 2, 53, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (57, 2, 11, '2', 0,'Generate ID Card','generate_id_card','generate_id_card','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (58, 2, 57, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (59, 2, 57, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (60, 2, 57, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        -- end Admin Menu

        -- Start Student


        (61, 3, 0, '1', 0,'Student Info','','student_information','flaticon-reading', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (62, 3, 61, '2', 0,'Add Student','student_admission','add_student','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (63, 3, 62, '3', 0,'Import Student','','import_student','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (64, 3, 61, '2', 0,'Student List','student_list','student_list','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (65, 3, 64, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (66, 3, 64, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (67, 3, 64, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (68, 3, 61, '2', 0,'Student Attendance','student_attendance','student_attendance','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (69, 3, 68, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (70, 3, 61, '2', 0,'Student Attendance Report','student_attendance_report','student_attendance_report','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (71, 3, 61, '2', 0,'Student Category','student_category','student_category','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (72, 3, 71, '3',0, 'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (73, 3, 71, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (74, 3, 71, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (75, 3, 71, '3', 0,'Download','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (76, 3, 61, '2', 0,'Student Group','student_group','student_group','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (77, 3, 76, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (79, 3, 76, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (80, 3, 76, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (81, 3, 61, '2', 0,'Student Promote','student_promote','student_promote','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (82, 3, 81, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (83, 3, 61, '2', 0,'Disabled Students','disabled_student','disabled_student','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (84, 3, 83, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (85, 3, 83, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (86, 3, 83, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),


        (663, 3, 61, '2', 0,'Student Export','all-student-export','student_export','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (664, 3, 663, '3', 0,'Export To CSV','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (665, 3, 663, '3', 0,'Export To PDF','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (950, 3, 61, '2', 0,'Time Setup','notification_time_setup','time_setup','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),


        -- end Student Menu

    -- Start Teacher Menu

        (87, 4, 0, '1', 0,'Study Material','','study_material','flaticon-professor', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (88, 4, 87, '2', 0,'Upload Content','upload-content','upload_content','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (89, 4, 88, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (586, 4, 88, '3', 0,'edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (90, 4, 88, '3', 0,'Download','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (91, 4, 88, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (92, 4, 87, '2', 0,'Assignment', 'assignment-list','assignment','',1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (93, 4, 92, '3', 0,'Add','','','',0, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (587, 4, 92, '3', 0,'edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (94, 4, 92, '3', 0,'Download','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (95, 4, 92, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

 

        (100, 4, 87, '2', 0,'Syllabus','syllabus-list','syllabus','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (101, 4, 100, '3', 0,'Add','','','',0, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (102, 4, 100, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (103, 4, 100, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (104, 4, 100, '3', 0,'Download','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (105, 4, 87, '2', 0,'Other Downloads','other-download-list','other_download','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (588, 4, 105, '3', 0,'edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (106, 4, 105, '3', 0,'Download','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (107, 4, 105, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        -- end Teacher Menu

        -- Start Fees Collection Menu

        (108, 5, 0, '1', 0,'Fees Collection','','fees_collection','flaticon-wallet', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (109, 5, 108, '2', 0,'Collect Fees','collect_fees','collect_fees','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (110, 5, 109, '3', 0,' Collect Fees','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (111, 5, 109, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (112, 5, 109,'3', 0,'Print','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (113, 5, 108, '2', 0,'Search Fees Payment','search_fees_payment','search_fees_payment','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (114, 5, 113, '3', 0,'Add','','','',0, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (115, 5, 113, '3', 0,'View','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (116, 5, 108, '2', 0,'Search Fees Due','search_fees_due','search_fees_due','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (117, 5, 116, '3', 0,'View','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (118, 5, 108, '2', 0,'Fees Master','fees-master','fees_master','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (119, 5, 118, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (120, 5, 118, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (121, 5, 118, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (122, 5, 118, '3', 0,'Assign','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (123, 5, 108, '2', 0,'Fees Group','fees_group','fees_group','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (124, 5, 123, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (125, 5, 123, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (126, 5, 123, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (127, 5, 108, '2', 0,'Fees Type','fees_type','fees_type','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (128, 5, 127, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (129, 5, 127, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (130, 5, 127, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (131, 5, 108, '2', 0,'Fees Discount','fees_discount','fees_discount','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (132, 5, 131, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (133, 5, 131, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (134, 5, 131, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (135, 5, 131, '3', 0,'Assign','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (136, 5, 108, '3', 0,'Fees Carry Forward','fees_forward','fees_forward','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (840, 5, 108, '2', 0,'Report','','report','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (383, 5, 840, '3', 0,'Collection Report','transaction_report','collection_report','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        
        (871, 5, 108, '2', 0,'Bank Payment','bank-payment-slip','bank_payment','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

         -- End Fees Collection Menu

         -- Start Accounts Menu

        (137, 6, 0, '1', 0,'Accounts','','accounts','flaticon-accounting', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (148, 6, 137, '2', 0,'Chart of Account','chart-of-account','chart_of_account','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (149, 6, 148, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (150, 6, 148, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (151, 6, 148, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (156, 6, 137, '2', 0,'Bank Account','bank-account','bank_account','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (157, 6, 156, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        -- (158, 6, 156, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (158, 6, 156, '3', 0,'Bank Transaction','','bank_transaction','',1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (159, 6, 156, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (139, 6, 137, '2', 0,'Income','add_income','income','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (140, 6, 139, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (141, 6, 139, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (142, 6, 139, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (143, 6, 137, '2', 0,'Expense','add-expense','expense','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (144, 6, 143, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (145, 6, 143, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (146, 6, 143, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (138, 6, 137, '2', 0,'Profit & Loss','profit','profit_&_loss','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        -- (147, 6, 137, '2', 0,'Search Menu','search-account','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (704, 6, 137, '2', 0,'Fund Transfer','fund-transfer','fund_transfer','',1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (705, 6, 704, '3', 0,'Transfer','','transfer','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (700, 6, 137, '2', 0,'Report','','report','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (701, 6, 700, '3', 0,'Fine Report','fine-report','fine_report','',1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (702, 6, 700, '3', 0,'Payroll Report','accounts-payroll-report','payroll_report','',1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (703, 6, 700, '3', 0,'Transaction','transaction','transaction','',1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        -- End Accounts Menu

        -- Start Human Resource Menu

        (160, 7, 0, '1', 0,'Human Resource','','human_resource','flaticon-consultation', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (712, 7, 160, '2', 0,'Add Staff','addStaff','add_staff','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (161, 7, 160, '2', 0,'Staff Directory','staff_directory','staff_directory','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (162, 7, 161, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (163, 7, 161, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (164, 7, 161, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (165, 7, 160, '2', 0,'Staff Attendance','staff_attendance','staff_attendance','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (166, 7, 165, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (167, 7, 165, '3', 0,'Edit','','','', 0, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (168, 7, 165, '3', 0,'Delete','','','', 0, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (169, 7, 160, '2', 0,'Staff Attendance Report','staff_attendance_report','staff_attendance_report','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (170, 7, 160, '2', 0,'Payroll','payroll','payroll','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (171, 7, 170, '3', 0,'Edit','','','', 0, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (172, 7, 170, '3', 0,'Delete','','','', 0, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (173, 7, 170, '3', 0,'Search','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (174, 7, 170, '3', 0,'Generate Payroll','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (175, 7, 170, '3', 0,'Create','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (176, 7, 170, '3', 0,'Proceed To Pay','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (177, 7, 170, '3', 0,'View Payslip','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (178, 7, 160, '2', 0,'Payroll Report','payroll-report','payroll_report','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (179, 7, 178, '3', 0,'Report Search','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (180, 7, 160, '2', 0,'Designation','designation','designation','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (181, 7, 180, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (182, 7, 180, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (183, 7, 180, '3',0, 'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (184, 7, 160, '2', 0,'Department','department','department','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (185, 7, 184, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (186, 7, 184, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (187, 7, 184, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        -- End Human Resource Menu

        -- Start Leave Menu

        (188, 8, 0, '1', 0,'Leave','','leave','flaticon-slumber', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (189, 8, 188, '2', 0,'Approve Leave Request','approve-leave','approve_leave_request','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (190, 8, 189, '3', 0,'Add','','','',0, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (191, 8, 189, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (192, 8, 189, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (193, 8, 188, '2', 0,'Apply Leave','apply-leave','apply_leave','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (194, 8, 193, '3', 0,'View','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (195, 8, 193, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (196, 8, 188, '2', 0,'Pending Leave','pending-leave','pending_leave_request','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (197, 8, 196, '3', 0,'View','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (198, 8, 196, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (199, 8, 188, '2', 0,'Leave Define','leave-define','leave_define','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (200, 8, 199, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (201, 8, 199, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (202, 8, 199, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (203, 8, 188, '2', 0,'Leave Type','leave-type','leave_type','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (204, 8, 203, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (205, 8, 203, '3', 0,'Edit','','','',1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (206, 8, 203, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        -- End Leave Menu

        -- Start Custom Field Menu
        (1100, 100, 0, '1', 0,'Custom Field','','custom_field','flaticon-slumber', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (1101, 100, 1100, '2', 0,'Student Registration','student-reg-custom-field','student_registration','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (1102, 100, 1101, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (1103, 100, 1101, '3', 0,'Edit','','','',1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (1104, 100, 1101, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (1105, 100, 1100, '2', 0,'Staff Registration','staff-reg-custom-field','staff_registration','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (1106, 100, 1105, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (1107, 100, 1105, '3', 0,'Edit','','','',1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (1108, 100, 1105, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        -- End Custom Field Menu

        -- Wallet Menu Start
        (1109, 150, 0, '1', 0,'Wallet','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (1110, 150, 1109, '2', 0,'Pending Diposite','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (1111, 150, 1110, '3', 0,'Approve','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (1112, 150, 1110, '3', 0,'Reject','','','',1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (1113, 150, 1110, '3', 0,'Download','','','',1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (1114, 150, 1109, '2', 0,'Approve Diposite','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (1115, 150, 1114, '2', 0,'Download','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        
        (1116, 150, 1109, '2', 0,'Reject Diposite','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (1117, 150, 1116, '2', 0,'Download','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (1118, 150, 1109, '2', 0,'Wallet Transaction','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (1119, 150, 1109, '2', 0,'Wallet Refund Request','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (1120, 150, 1119, '2', 0,'Approve','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (1121, 150, 1119, '2', 0,'Reject','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (1122, 150, 1119, '2', 0,'Download','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (1123, 150, 1109, '2', 0,'Wallet Report','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        -- Wallet Menu End

        -- Fees
        (1130, 250, 0, '1', 0,'Fees','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (1131, 250, 1130, '2', 0,'Fees Group','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (1132, 250, 1131, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (1133, 250, 1131, '3', 0,'Edit','','','',1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (1134, 250, 1131, '3', 0,'Delete','','','',1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (1135, 250, 1130, '2', 0,'Fees Type','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (1136, 250, 1135, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (1137, 250, 1135, '3', 0,'Edit','','','',1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (1138, 250, 1135, '3', 0,'Delete','','','',1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (1139, 250, 1130, '2', 0,'Fees Invoice','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (1140, 250, 1139, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (1141, 250, 1139, '3', 0,'View Payment','','','',1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (1142, 250, 1139, '3', 0,'View','','','',1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (1143, 250, 1139, '3', 0,'print','','','',1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (1144, 250, 1139, '3', 0,'Add Payment','','','',1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (1145, 250, 1139, '3', 0,'Edit','','','',1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (1146, 250, 1139, '3', 0,'Delete','','','',1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (1147, 250, 1139, '3', 0,'Fees Collect','','','',1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (1148, 250, 1130, '2', 0,'Bank Payment','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (1149, 250, 1148, '3', 0,'Search','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (1150, 250, 1148, '3', 0,'Approve Payment','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (1151, 250, 1148, '3', 0,'Reject Payment','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (1152, 250, 1130, '2', 0,'Fees Invoice Settings','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (1153, 250, 1152, '3', 0,'Update','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (1154, 250, 1130, '2', 0,'Fees Due','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (1155, 250, 1154, '3', 0,'Search','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        
        -- Start Examination Menu

        (207, 9, 0, '1', 0,'Examination','','examination','flaticon-test', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (208, 9, 207, '2', 0,'Exam Type','exam-type','exam_type','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (209, 9, 208, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (210, 9, 208, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (211, 9, 208, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),



        (214, 9, 207, '2', 0,'Exam Setup','exam','exam_setup','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (215, 9, 214, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (216, 9, 214, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (217, 9, 207, '2', 0,'Exam Schedule','exam_schedule','exam_schedule','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (218, 9, 217, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (219, 9, 217, '3', 0,'Create','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (220, 9, 207, '2', 0,'Exam Attendance','exam_attendance','exam_attendance','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (221, 9, 220, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (222, 9, 207, '2', 0,'Marks Register','marks_register','marks_register','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (223, 9, 222, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (224, 9, 222, '3', 0,'Create','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (225, 9, 207, '2', 0,'Marks Grade','marks-grade','marks_grade','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (226, 9, 225, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (227, 9, 225, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (228, 9, 225, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (229, 9, 207, '2', 0,'Send Marks By SMS','send_marks_by_sms','send_marks_by_sms','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        

        (870, 9, 207, '2', 0,'Settings','','settings','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (436, 9, 870, '2', 0,'Setup Exam Rule','custom-result-setting','setup_exam_role','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (437, 9, 436, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (438, 9, 436, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (439, 9, 436, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (706, 9, 870, '2',0, 'Format Settings','exam-settings','format_settings','',1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (707, 9, 706, '3',0, 'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (708, 9, 706, '3',0, 'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (709, 9, 706, '3',0, 'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
   
         
        (245, 10, 0, '1', 0,'Academics','','academics','flaticon-book', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (246, 10, 245, '2', 0,'Class Routine','class_routine_new','class_routine','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (247, 10, 246, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (248, 10, 246, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (249, 10, 246, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (250, 10, 245, '2', 0,'Assign Subject','assign_subject','assign_subject','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (251, 10, 250, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (252, 10, 250, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (253, 10, 245, '2', 0,'Assign Class Teacher','assign-class-teacher','assign_class_teacher','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (254, 10, 253, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (255, 10, 253, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (256, 10, 253, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (257, 10, 245, '2', 0,'Subjects','subject','subject','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (258, 10, 257, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (259, 10, 257, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (260, 10, 257, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (261, 10, 245, '2', 0,'Class','class','class','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (262, 10, 261, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (263, 10, 261, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (264, 10, 261, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (265, 10, 245, '2', 0,'Section','section','section','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (266, 10, 265, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (267, 10, 265, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (268, 10, 265, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (269, 10, 245, '2', 0,'Class Room','class-room','class_room','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (270, 10, 269, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (271, 10, 269, '3',0, 'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (272, 10, 269, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (273, 10, 245, '2',0, 'Class Time Setup','class-time','class_time_setup','', 0, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (274, 10, 273, '3',0, 'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (275, 10, 273, '3',0, 'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (276, 10, 273, '3',0, 'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        -- End  Academics Menu


        -- Start Online Exam Menu
        (875, 35, 0, '1', 0,'Online Exam','','online_exam','flaticon-book-1', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (230, 35, 875, '2', 0,'Question Group','question-group','question_group','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (231, 35, 230, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (232, 35, 230, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (233, 35, 230, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (234, 35, 875, '2', 0,'Question Bank','question-bank','question_bank','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (235, 35, 234, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (236, 35, 234, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (237, 35, 234, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (238, 35, 875, '2', 0,'Online Exam','online-exam','online_exam','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (239, 35, 238, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (240, 35, 238, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (241, 35, 238, '3',0, 'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (242, 35, 238, '3', 0,'Manage Question','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (243, 35, 238, '3',0, 'Marks Register','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (244, 35, 238, '3',0, 'Result','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        -- End Online Exam Menu

        -- Start  Homework Menu

        (277, 11, 0, '1', 0,'Homework','','home_work','flaticon-book', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (278, 11, 277, '2', 0,'Add Homework','add-homeworks','add_homework','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (279, 11, 278, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (280, 11, 277, '2', 0,'Homework List','homework-list','homework_list','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (281, 11, 280, '3', 0,'Evaluation','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (282, 11, 280, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (283, 11, 280, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (284, 11, 277, '2', 0,'Homework Evaluation Report','evaluation-report','evaluation_report','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (285, 11, 284, '3', 0,'View','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
         -- End  Homework Menu

         -- lesson Plan

        (800, 29, 0, '1', 0,'Lesson','','lesson','flaticon-professor', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (801, 29, 800, '1', 0,'Lesson','lesson','lesson','',1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (802, 29, 801, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (803, 29, 801, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (804, 29, 801, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (805, 29, 800, '1', 0,'Topic','lesson.topic','topic','',1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (806, 29, 805, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (807, 29, 805, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (808, 29, 805, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (809, 29, 800, '1', 0,'Topic Overview','topic-overview','topic_overview','',1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
      
        (810, 29, 800, '1', 0,'Lesson Plan','lesson.lesson-planner','lesson_plan','',1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (811, 29, 810, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (812, 29, 810, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (813, 29, 810, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (814, 29, 810, '3', 0,'view','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (815, 29, 800, '1', 0,'Lesson Plan Overview','lesson.lessonPlan-overiew','lesson_plan_overview','',1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (833, 29, 800, '1', 0,'My Lesson Plan ','view-teacher-lessonPlan','my_lesson_plan','',1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (834, 29, 800, '1', 0,'My Lesson Plan Overview','view-teacher-lessonPlan-overview','my_lesson_plan_overview','',1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        -- End Lesson
  
        -- start Jitsi

        (816, 30, 0, '1', 0,'Jitsi','','jitsi_virtual_class','flaticon-reading', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (817, 30, 816, '2', 0,'Virtual Class','jitsi.virtual-class','virtual_class','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (818, 30, 817, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (819, 30, 817, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (820, 30, 817, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (821, 30, 817, '3', 0,'Start Class','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (822, 30, 816, '2', 0,'Virtual Meeting','jitsi.meetings','virtual_meeting','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),       
        (823, 30, 822, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (824, 30, 822, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (825, 30, 822, '3',0, 'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (826, 30, 822, '3', 0,'Start Meeting','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (827, 30, 816, '2', 0,'Class Report','jitsi.virtual.class.reports.show','class_reports','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (828, 30, 827, '3', 0,'Search','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (829, 30, 816, '2', 0,'Meeting Report','jitsi.meeting.reports.show','meeting_reports','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (830, 30, 829, '3', 0,'Search','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (831, 30, 816, '2', 0,'Settings','jitsi.settings','settings','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (832, 30, 831, '3', 0,'Update','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        -- end jitsi

         -- bbb
        (850, 33, 0, '1', 0,'BigBlueButton','','bbb','flaticon-reading', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (851, 33, 850, '2', 0,'Virtual Class','bbb.virtual-class','virtual_class','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (852, 33, 851, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (853, 33, 851, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (854, 33, 851, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (855, 33, 851, '3', 0,'Start Class','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (856, 33, 850, '2', 0,'Virtual Meeting','bbb.meetings','virtual_meeting','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (857, 33, 856, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (859, 33, 856, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (860, 33, 856, '3',0, 'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (861, 33, 856, '3', 0,'Start Meeting','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (862, 33, 850, '2', 0,'Class Report','bbb.virtual.class.reports.show','class_reports','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (863, 33, 862, '3', 0,'Search','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (864, 33, 850, '2', 0,'Meeting Report','bbb.meeting.reports.show','meeting_reports','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (865, 33, 864, '3', 0,'Search','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

      
        (866, 33, 850, '2', 0,'Settings','bbb.settings','settings','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (867, 33, 866, '3', 0,'Update','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (868, 33, 850, '2', 0,'Class Recorded List','bbb.class.recording.list','class_recorded_list','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (869, 33, 850, '2', 0,'Meeting Recorded List','bbb.meeting.recording.list','meeting_recorded_list','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        
        -- end bbb
        
         -- Start  Communicate Menu

        (286, 12, 0, '1', 0,'Communicate','','communicate','flaticon-email', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (287, 12, 286, '2', 0,'Notice Board','notice-list','notice_board','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (288, 12, 287, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (289, 12, 287, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (290, 12, 287, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (291, 12, 286, '2', 0,'Send Email / SMS ','send-email-sms-view','send_email','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (292, 12, 291, '3', 0,'Send','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (293, 12, 286, '2', 0,'Email / SMS Log','email-sms-log','email_sms_log','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (294, 12, 286, '2', 0,'Event','event','event','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (295, 12, 294, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (296, 12, 294, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (297, 12, 294, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (710, 12, 286, '2', 0,'Sms Templete','sms-template-new','sms_template','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (711, 12, 710, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (480, 12, 286, '2', 0,'Email Template','templatesettings.email-template','email_templete','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (481, 12, 480, '3', 0,'Save','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

         -- End  Communicate Menu

         -- start library module

        (298, 13, 0, '1', 0,'Library','','library','flaticon-book-1', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (299, 13, 298, '2', 0,'Add Book','add-book', 'add_book','',1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (300, 13, 299, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (301, 13, 298, '2', 0,'Book List ','book-list','book_list','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (302, 13, 301, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (303, 13, 301, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (304, 13, 298, '2', 0,'Book Categories','book-category-list','book_category','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (305, 13, 304, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (306, 13, 304, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (307, 13, 304, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (308, 13, 298, '2', 0,'Add Member','library-member','library_member','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (309, 13, 308, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (310, 13, 308, '3', 0,'Cancel','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (311, 13, 298, '2', 0,'Issue/Return Book','member-list','member_list','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (312, 13, 311, '3', 0,'Issue','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (313, 13, 311, '3', 0,'Return','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (314, 13, 298, '2', 0,'All Issued Book','all-issed-book','all_issued_book','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
          -- End  Library Menu

          -- Start Invemtory Menu
        (315, 14, 0, '1', 0,'Inventory','','inventory','flaticon-inventory', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (316, 14, 315, '2', 0,'Item Category','item-category','item_category','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (317, 14, 316, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (318, 14, 316, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (319, 14, 316, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (320, 14, 315, '2', 0,'Item List','item-list','item_list','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (321, 14, 320, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (322, 14, 320, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (323, 14, 320, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (324, 14, 315, '2', 0,'Item Store','item-store','item_store','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (325, 14, 324, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (326, 14, 324, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (327, 14, 324, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (328, 14, 315, '2', 0,'Supplier','suppliers','supplier','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (329, 14, 328, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (330, 14, 328, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (331, 14, 328, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (332, 14, 315, '2', 0,'Item Receive','item-receive','item_receive','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (333, 14, 332, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (334, 14, 315, '2', 0,'Item Receive List','item-receive-list','item_receive_list','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (335, 14, 334, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (336, 14, 334, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (337, 14, 334, '3', 0,'View','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (338, 14, 334, '3', 0,'Cancel','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (339, 14, 315, '2', 0,'Item Sell','item-sell-list','item_sell','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (340, 14, 339, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (341, 14, 339, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (342, 14, 339, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (343, 14, 339, '3', 0,'Add Payment','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (344, 14, 339, '3', 0,'View Payment','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (345, 14, 315, '2', 0,'Item Issue','item-issue','item_issue','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (346, 14, 345, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (347, 14, 345, '3', 0,'Return','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

         -- End  Inventory Menu

         -- Start Transport Menu

        (348, 15, 0, '1', 0,'Transport','','transport','flaticon-bus', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (349, 15, 348, '2', 0,'Routes','transport-route','routes','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (350, 15, 349, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (351, 15, 349, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (352, 15, 349, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (353, 15, 348, '2', 0,'Vehicle','vehicle','vehicle','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (354, 15, 353, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (355, 15, 353, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (356, 15, 353, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (357, 15, 348, '2', 0,'Assign Vehicle','assign-vehicle','assign_vehicle','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (358, 15, 357, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (359, 15, 357, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (360, 15, 357, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (361, 15, 348, '2', 0,'Student Transport Report','student_transport_report','student_transport_report','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
         -- End  Transport Menu

          -- Start Dormitory Menu
        (362, 16, 0, '1', 0,'Dormitory','','dormitory','flaticon-hotel', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (363, 16, 362, '2', 0,'Dormitory Rooms','room-list','dormitory_rooms','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (364, 16, 363, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (365, 16, 363, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (366, 16, 363, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (367, 16, 362, '2', 0,'Dormitory','dormitory-list','dormitory','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (368, 16, 367, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (369, 16, 367, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (370, 16, 367, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (371, 16, 362, '2', 0,'Room Type','room-type','room_type','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (372, 16, 371, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (373, 16, 371, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (374, 16, 371, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (375, 16, 362, '2', 0,'Student Dormitory Report','student_dormitory_report','student_dormitory_report','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        -- End  Dormitory Menu

         -- Start  Reports Menu

        (376, 17, 0, '1', 0,'Reports','student_report','reports','flaticon-analysis', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (377, 17, 376, '2', 0,'Guardian Reports','guardian_report','guardian_report','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (378, 17, 376, '2', 0,'Student History','student_history','student_history','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (379, 17, 376, '2', 0,'Student Login Report','student_login_report','student_login_report','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (380, 17, 379, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (381, 17, 376, '2', 0,'Fees Statement','fees_statement','fees_statement','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (382, 17, 376, '2', 0,'Balance Fees Report','balance_fees_report','balance_fees_report','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (384, 17, 376, '2', 0,'Class Report','class_report','class_report','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (385, 17, 376, '2', 0,'Class Routine','class_routine_report','class_routine','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (386, 17, 376, '2', 0,'Exam Routine','exam_routine_report','exam_routine','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (387, 17, 376, '2', 0,'Teacher Class Routine','teacher_class_routine_report','teacher_class_routine','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (388, 17, 376, '2', 0,'Merit List Report','merit_list_report','merit_list_report','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (389, 17, 376, '2', 0,'Online Exam Report','online_exam_report','online_exam_report','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (390, 17, 376, '2',0, 'Mark Sheet Report','mark_sheet_report_student','mark_sheet_report','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (391, 17, 376, '2', 0,'Tabulation Sheet Report','tabulation_sheet_report','tabulation_sheet_report','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (392, 17, 376, '2', 0,'Progress Card Report','progress_card_report','progress_card_report','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),


        (394, 17, 376, '2', 0,'User Log','user_log','user_log','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (395, 8, 394, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (396, 8, 394, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (397, 9, 394, '3', 0,'Exam Setup Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),


        -- system settings
        (398, 18, 0, '1', 0,'System Settings','','system_settings','flaticon-settings', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (399, 18, 398, '2', 0,'Module Manager','manage-adons','module_manager','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (400, 18, 399, '3', 0,'Verify','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (4000, 18, 398, '2', 0,'Utilities','utility','utilities','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (401, 18, 398, '2', 0,'Manage Currency','manage-currency','manage_currency','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (402, 18, 401, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (403, 18, 401, '3',0, 'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (404, 18, 401, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (405, 18, 398, '2', 0,'General Settings','general-settings','general_settings','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (406, 18, 405, '3', 0,'Logo Change','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (407, 18, 405, '3', 0,'Fevicon Change','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (408, 18, 405, '3',0, 'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (409, 18, 405, '3', 0,'Update','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (410, 18, 398, '2', 0,'Email Setting','email-settings','email_settings','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (411, 18, 410, '3', 0,'Update','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (412, 18, 398, '2', 0,'Payment Method Settings','payment-method-settings','payment_method_settings','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (413, 18, 412, '3', 0,'Gateway Update','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (414, 18, 412, '3', 0,'PayPal Update','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (415, 18, 412, '3', 0,'Stripe Update','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (416, 18, 412, '3', 0,'Paystack Update','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (153, 6, 412, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (154, 6, 412, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (155, 6, 412, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),


        (424, 18, 398, '2', 0,'Optional Subject Setup','class_optional','optional_subject_setup','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (425, 18, 424, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (426, 18, 424, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (427, 18, 424, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (428, 18, 398, '2', 0,'Base Setup','','base_setup','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (429, 18, 428, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (430, 18, 428, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (431, 18, 428, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (432, 18, 398, '2', 0,'Academic Year','academic-year','academic_year','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (433, 18, 432, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (434, 18, 432, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (435, 18, 432, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),


        (440, 18, 398, '2', 0,'Holiday','holiday','holiday','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (441, 18, 440, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (442, 18, 440, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (443, 18, 440, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (444, 18, 398, '2', 0,'Sms Settings','sms-settings','sms_settings','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (445, 18, 444, '3', 0,' Select SMS Service','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (446, 18, 444, '3', 0,' Twilio Update','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (447, 18, 444, '3', 0,' MSG91 Update','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (448, 18, 398, '2', 0,'Weekend','weekend','weekend','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (449, 18, 448, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (450, 18, 448, '3', 0,'Update','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (451, 18, 398, '2', 0,'Language Settings','language-settings','language_settings','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (452, 18, 451, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (453, 18, 451, '3', 0,'Make Default','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (454, 18, 451, '3', 0,'Setup','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (455, 18, 451, '3', 0,'Remove','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (456, 18, 398, '2', 0,'Backup','backup-settings','backup','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (457, 18, 456, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (458, 18, 456, '3', 0,'Download','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (459, 18, 456, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (460, 18, 456, '3', 0,'Image','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (461, 18, 456, '3', 0,'Full Project','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (462, 18, 456, '3',0, 'Database','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (463, 18, 398, '2', 0,'Header Option','button-disable-enable','header','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (464, 18, 463, '3', 0,'Custom URL Update','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (465, 18, 463, '3', 0,'Website On','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (466, 18, 463, '3', 0,'Website Off','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (467, 18, 463, '3', 0,'Dashboard On','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (468, 18, 463, '3', 0,'Dashboard Off','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (469, 18, 463, '3', 0,'Report On','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (470, 18, 463, '3', 0,'Report Off','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (471, 18, 463, '3', 0,'Language On','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (472, 18, 463, '3', 0,'Language Off','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (473, 18, 463, '3', 0,'Style On','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (474, 18, 463, '3', 0,'Style Off','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (478, 18, 398, '2', 0,'About & Update','update-system','about_&_update','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (479, 18, 477, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (482, 18, 398, '2', 0,'API Permission','','api','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (483, 18, 482, '3', 0,'On','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (484, 18, 482, '3', 0,'Off','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        -- -- user management 
        (417, 23, 0, '1', 0,'Role & Permission','','role_&_permission','flaticon-authentication', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (585, 23, 417, '2', 0,'Role','rolepermission/role','role','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (418, 23, 585, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (419, 23, 585, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (420, 23, 585, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (541, 18, 585, '3', 0,'Assign Permission','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (421, 23, 417, '2', 0,'Login Permission','login-access-control','login_permission','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (422, 23, 421, '3', 0,'On','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (423, 23, 421, '3', 0,'Off','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        -- Style
        (485, 19, 0, '1', 0,'Style','','style','flaticon-consultation', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (486, 19, 485, '2', 0,'Background Settings','background-setting','background_settings','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (487, 19, 486, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (488, 19, 486, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (489, 19, 486, '3', 0,'Make Default','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (490, 19, 485, '2', 0,'Color Theme','color-style','color_theme','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (491, 19, 490, '3', 0,'Make Default','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        -- Front settings
        (492, 20, 0, '1', 0,'Front Settings','','front_settings','flaticon-software', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (493, 20, 492, '2', 0,'Home Page','admin-home-page','home_page','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (494, 20, 493, '3', 0,'Update','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (495, 20, 492, '2', 0,'News List','news_index','news_list','',1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (496, 20, 495, '3', 0,'View','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (497, 20, 495, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (498, 20, 495, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (499, 20, 495, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (500, 20, 492, '2', 0,'News Category','news-category','news_category','',1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (501, 20, 500, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (502, 20, 500, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (503, 20, 500, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (504, 20, 492, '2', 0,'Testimonial','testimonial_index','testimonial','',1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (505, 20, 504, '3', 0,'View','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (506, 20, 504, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (507, 20, 504, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (508, 20, 504, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (509, 20, 492, '2', 0,'Course List','course-list','course_list','',1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (510, 20, 509, '3',0, 'View','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (511, 20, 509, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (512, 20, 509, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (513, 20, 509, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        -- app slider(930-935)

        (514, 20, 492, '2', 0,'Contact Page','conpactPage','contact_page','',1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (515, 20, 514, '3', 0,'View','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (516, 20, 514, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (517, 20, 492, '2', 0,'Contact Messages','contactMessage','contact_message','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (519, 20, 517, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (520, 20, 492, '2', 0,'About Us','about-page','about_us','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (521, 20, 520, '3', 0,'View','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (522, 20, 520, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (523, 20, 492, '2', 0,'News Heading','news-heading-update','news_heading','',1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (524, 20, 523, '3', 0,'Update','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (525, 20, 492, '2', 0,'Course Details Heading','course-heading-update','course_details_heading','',1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (526, 20, 525, '3', 0,'Update','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (527, 20, 492, '2', 0,'Footer Widget','custom-links','footer_widget','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (528, 20, 527, '3', 0,'Update','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (529, 20, 492, '2', 0,'Social Media','social-media','social_media','',1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (530, 20, 529, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (531, 20, 529, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (532, 20, 529, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (650, 20, 492, '2', 0,'Header Menu Manager','header-menu-manager','header_menu_manager','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (651, 20, 650, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (652, 20, 650, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (653, 20, 650, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (654, 20, 492, '2', 0,'Pages','page-list','pages','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (655, 20, 654, '3', 0,'View','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (656, 20, 654, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (657, 20, 654, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (658, 20, 654, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (659, 20, 654, '3', 0,'Download','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (673, 20, 492, '2', 0,'Course Category','course-category','course_category','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (674, 20, 673, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (675, 20, 673, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (676, 20, 673, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),




        (533, 3, 61, '2', 0,'Subject Wise Attendance','subject-wise-attendance','subject_wise_attendance','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (534, 3, 533, '3', 0,'Save','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (535, 3, 61, '2', 0,'Subject Wise Attendance Report','subject-attendance-report','subject_wise_attendance_report','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (536, 3, 535, '3', 0,'Print','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (537, 10, 245, '2',0, 'Optional Subject','optional-subject','optional_subject','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (538, 17, 376, '2', 0,'Student Report','student_report','student_report','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (539, 17, 376, '2',0, 'Previous Result','previous-class-results','previous_class_result','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (540, 17, 376, '2', 0,'previous record','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        


        (542, 21, 0, '1', 0,'Registration','','registration','flaticon-reading', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (543, 21, 542, '2', 0,'Student List','parentregistration.student-list','student_list','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (544, 21, 543, '3', 0,'View','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (545, 21, 543, '3', 0,'Approve','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (546, 21, 543, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (547, 21, 542, '2', 0,'Settings','parentregistration/settings','settings','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (548, 21, 547, '3', 0,'Update','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (549, 18, 398, '2', 0,'Language','language-list','language','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (550, 18, 549, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (551, 18, 549, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (552, 18, 549, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (553, 8, 193, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (554, 22, 0, '1', 0,'Virtual Class','','virtual_class','flaticon-reading', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (555, 22, 554, '2', 0,'Virtual Class','zoom.virtual-class','virtual_class','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (556, 22, 555, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (557, 22, 555, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (558, 22, 555, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (559, 22, 555, '3', 0,'Start Class','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (560, 22, 554, '2', 0,'Virtual Meeting','zoom.meetings','virtual_meeting','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (561, 22, 560, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (562, 22, 560, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (563, 22, 560, '3',0, 'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (564, 22, 560, '3', 0,'Start Meeing','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (565, 22, 554, '2', 0,'Class Report','zoom.virtual.class.reports.show','class_reports','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (566, 22, 565, '3', 0,'Search','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (567, 22, 554, '2', 0,'Meeting Report','zoom.meeting.reports.show','meeting_reports','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (568, 22, 567, '3', 0,'Search','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (569, 22, 554, '2', 0,'Settings','zoom.settings','settings','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (570, 22, 569, '3', 0,'Update','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (571, 9, 207, '2', 0,'Exam Time','exam-time','exam_time','', 0, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (572, 9, 571, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (573, 9, 571, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (574, 9, 571, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

        (577, 7, 161, '3', 0,'Status On','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (578, 7, 161, '3', 0,'Status Off','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),

     

        (579, 13, 298, '2', 0,'Subject','library_subject','subject','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (580, 13, 579, '3', 0,'Add','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (581, 13, 579, '3', 0,'Edit','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (582, 13, 579, '3', 0,'Delete','','','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        
        -- Chat 
        (900, 31, 0, '1', 0,'Chat','','chat','flaticon-test',1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (901, 31, 900, '2', 0,'Chat Box','chat.index','chat_box','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (902, 31, 901, '3', 0,'New Chat','','','',1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (903, 31, 900, '2', 0,'Invitation','chat.invitation','invitation','',1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (904, 31, 900, '2', 0,'Blocked User','chat.blocked.users','blocked_user','',1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (905, 31, 900, '2', 0,'Chat Settings','chat.settings','chat_settings','',1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        
        -- Bulk Print
        (920, 36, 0, '1', 0,'Bulk Print','','bulk_print','flaticon-analysis', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (921, 36, 920, '2', 0,'Student Id Card','student-id-card-bulk-print','student_id_card','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (922, 36, 920, '2', 0,'Student Certificate','certificate-bulk-print','student_certificate','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (923, 36, 920, '2', 0,'Staff Id Card','staff-id-card-bulk-print','staff_id_card','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (924, 36, 920, '2', 0,'PayrollBulk Print','payroll-bulk-print','payroll_bulk_print','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (925, 36, 920, '2', 0,'Fees Invoice Settings','invoice-settings','fees_invoice_settings','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22'),
        (926, 36, 920, '2', 0,'Fees invoice Bulk Print','fees-bulk-print','fees_invoice_bulk_print','', 1, 1, 1, 1, '2019-07-25 02:21:21', '2019-07-25 04:24:22')


        

        ");
            DB::insert($sql);
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('infix_module_infos');
    }
}
